// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 \
// RUN:   -triple aarch64 -target-feature +neon -target-feature +bf16 \
// RUN:   -disable-O0-optnone -emit-llvm -o - %s \
// RUN:   | opt -S -passes=mem2reg \
// RUN:   | FileCheck --check-prefixes=CHECK,CHECK-A64 %s
// RUN: %clang_cc1 \
// RUN:   -triple armv8.6a-arm-none-eabi -target-feature +neon \
// RUN:   -target-feature +bf16 -mfloat-abi hard \
// RUN:   -disable-O0-optnone -emit-llvm -o - %s \
// RUN:   | opt -S -passes=mem2reg \
// RUN:   | FileCheck --check-prefixes=CHECK,CHECK-A32-HARDFP %s
// RUN: %clang_cc1 \
// RUN:   -triple armv8.6a-arm-none-eabi -target-feature +neon \
// RUN:   -target-feature +bf16 -mfloat-abi softfp \
// RUN:   -disable-O0-optnone -emit-llvm -o - %s \
// RUN:   | opt -S -passes=mem2reg \
// RUN:   | FileCheck --check-prefixes=CHECK,CHECK-A32-SOFTFP %s

// REQUIRES: arm-registered-target
// REQUIRES: aarch64-registered-target

#include <arm_neon.h>

// CHECK-A64-LABEL: @test_vcvt_f32_bf16(
// CHECK-A64-NEXT:  entry:
// CHECK-A64-NEXT:    [[__REINT_150_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A64-NEXT:    [[__REINT1_150_I:%.*]] = alloca <4 x i32>, align 16
// CHECK-A64-NEXT:    store <4 x bfloat> [[A:%.*]], ptr [[__REINT_150_I]], align 8
// CHECK-A64-NEXT:    [[TMP1:%.*]] = load <4 x i16>, ptr [[__REINT_150_I]], align 8
// CHECK-A64-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CHECK-A64-NEXT:    [[TMP3:%.*]] = sext <4 x i16> [[TMP1]] to <4 x i32>
// CHECK-A64-NEXT:    [[VSHLL_N_I:%.*]] = shl <4 x i32> [[TMP3]], <i32 16, i32 16, i32 16, i32 16>
// CHECK-A64-NEXT:    store <4 x i32> [[VSHLL_N_I]], ptr [[__REINT1_150_I]], align 16
// CHECK-A64-NEXT:    [[TMP5:%.*]] = load <4 x float>, ptr [[__REINT1_150_I]], align 16
// CHECK-A64-NEXT:    ret <4 x float> [[TMP5]]
//
// CHECK-A32-HARDFP-LABEL: @test_vcvt_f32_bf16(
// CHECK-A32-HARDFP-NEXT:  entry:
// CHECK-A32-HARDFP-NEXT:    [[__REINT_150_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-HARDFP-NEXT:    [[__REINT1_150_I:%.*]] = alloca <4 x i32>, align 8
// CHECK-A32-HARDFP-NEXT:    store <4 x bfloat> [[A:%.*]], ptr [[__REINT_150_I]], align 8
// CHECK-A32-HARDFP-NEXT:    [[TMP1:%.*]] = load <4 x i16>, ptr [[__REINT_150_I]], align 8
// CHECK-A32-HARDFP-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CHECK-A32-HARDFP-NEXT:    [[TMP3:%.*]] = sext <4 x i16> [[TMP1]] to <4 x i32>
// CHECK-A32-HARDFP-NEXT:    [[VSHLL_N_I:%.*]] = shl <4 x i32> [[TMP3]], <i32 16, i32 16, i32 16, i32 16>
// CHECK-A32-HARDFP-NEXT:    store <4 x i32> [[VSHLL_N_I]], ptr [[__REINT1_150_I]], align 8
// CHECK-A32-HARDFP-NEXT:    [[TMP5:%.*]] = load <4 x float>, ptr [[__REINT1_150_I]], align 8
// CHECK-A32-HARDFP-NEXT:    ret <4 x float> [[TMP5]]
//
// CHECK-A32-SOFTFP-LABEL: @test_vcvt_f32_bf16(
// CHECK-A32-SOFTFP-NEXT:  entry:
// CHECK-A32-SOFTFP-NEXT:    [[__P0_150_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__REINT_150_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__REINT1_150_I:%.*]] = alloca <4 x i32>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[A:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[A_COERCE:%.*]], ptr [[A]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[A1:%.*]] = load <4 x bfloat>, ptr [[A]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[A1]], ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP2:%.*]] = load <2 x i32>, ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP2]], ptr [[__P0_150_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_1501_I:%.*]] = load <4 x bfloat>, ptr [[__P0_150_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[__P0_1501_I]], ptr [[__REINT_150_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP5:%.*]] = load <4 x i16>, ptr [[__REINT_150_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP6:%.*]] = bitcast <4 x i16> [[TMP5]] to <8 x i8>
// CHECK-A32-SOFTFP-NEXT:    [[TMP7:%.*]] = sext <4 x i16> [[TMP5]] to <4 x i32>
// CHECK-A32-SOFTFP-NEXT:    [[VSHLL_N_I:%.*]] = shl <4 x i32> [[TMP7]], <i32 16, i32 16, i32 16, i32 16>
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[VSHLL_N_I]], ptr [[__REINT1_150_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP9:%.*]] = load <4 x float>, ptr [[__REINT1_150_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    ret <4 x float> [[TMP9]]
//
float32x4_t test_vcvt_f32_bf16(bfloat16x4_t a) {
  return vcvt_f32_bf16(a);
}

// CHECK-A64-LABEL: @test_vcvtq_low_f32_bf16(
// CHECK-A64-NEXT:  entry:
// CHECK-A64-NEXT:    [[__REINT_150_I_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A64-NEXT:    [[__REINT1_150_I_I:%.*]] = alloca <4 x i32>, align 16
// CHECK-A64-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x bfloat> [[A:%.*]], <8 x bfloat> [[A]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
// CHECK-A64-NEXT:    store <4 x bfloat> [[SHUFFLE_I]], ptr [[__REINT_150_I_I]], align 8
// CHECK-A64-NEXT:    [[TMP1:%.*]] = load <4 x i16>, ptr [[__REINT_150_I_I]], align 8
// CHECK-A64-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CHECK-A64-NEXT:    [[TMP3:%.*]] = sext <4 x i16> [[TMP1]] to <4 x i32>
// CHECK-A64-NEXT:    [[VSHLL_N_I_I:%.*]] = shl <4 x i32> [[TMP3]], <i32 16, i32 16, i32 16, i32 16>
// CHECK-A64-NEXT:    store <4 x i32> [[VSHLL_N_I_I]], ptr [[__REINT1_150_I_I]], align 16
// CHECK-A64-NEXT:    [[TMP5:%.*]] = load <4 x float>, ptr [[__REINT1_150_I_I]], align 16
// CHECK-A64-NEXT:    ret <4 x float> [[TMP5]]
//
// CHECK-A32-HARDFP-LABEL: @test_vcvtq_low_f32_bf16(
// CHECK-A32-HARDFP-NEXT:  entry:
// CHECK-A32-HARDFP-NEXT:    [[__REINT_150_I_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-HARDFP-NEXT:    [[__REINT1_150_I_I:%.*]] = alloca <4 x i32>, align 8
// CHECK-A32-HARDFP-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x bfloat> [[A:%.*]], <8 x bfloat> [[A]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
// CHECK-A32-HARDFP-NEXT:    store <4 x bfloat> [[SHUFFLE_I]], ptr [[__REINT_150_I_I]], align 8
// CHECK-A32-HARDFP-NEXT:    [[TMP1:%.*]] = load <4 x i16>, ptr [[__REINT_150_I_I]], align 8
// CHECK-A32-HARDFP-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CHECK-A32-HARDFP-NEXT:    [[TMP3:%.*]] = sext <4 x i16> [[TMP1]] to <4 x i32>
// CHECK-A32-HARDFP-NEXT:    [[VSHLL_N_I_I:%.*]] = shl <4 x i32> [[TMP3]], <i32 16, i32 16, i32 16, i32 16>
// CHECK-A32-HARDFP-NEXT:    store <4 x i32> [[VSHLL_N_I_I]], ptr [[__REINT1_150_I_I]], align 8
// CHECK-A32-HARDFP-NEXT:    [[TMP5:%.*]] = load <4 x float>, ptr [[__REINT1_150_I_I]], align 8
// CHECK-A32-HARDFP-NEXT:    ret <4 x float> [[TMP5]]
//
// CHECK-A32-SOFTFP-LABEL: @test_vcvtq_low_f32_bf16(
// CHECK-A32-SOFTFP-NEXT:  entry:
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_I2:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_150_I_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__REINT_150_I_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__REINT1_150_I_I:%.*]] = alloca <4 x i32>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_I:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE_I:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE2_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE3_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[A:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[A_COERCE:%.*]], ptr [[A]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[A1:%.*]] = load <8 x bfloat>, ptr [[A]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[A1]], ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[TMP2]], ptr [[__P0_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P01_I:%.*]] = load <8 x bfloat>, ptr [[__P0_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[__P01_I]], ptr [[COERCE_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP5:%.*]] = load <4 x i32>, ptr [[COERCE_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[TMP5]], ptr [[__P0_I2]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P01_I5:%.*]] = load <8 x bfloat>, ptr [[__P0_I2]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x bfloat> [[__P01_I5]], <8 x bfloat> [[__P01_I5]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[SHUFFLE_I]], ptr [[RETVAL_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP8:%.*]] = load <2 x i32>, ptr [[RETVAL_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP8]], ptr [[COERCE2_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP10:%.*]] = load <4 x bfloat>, ptr [[COERCE2_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[TMP10]], ptr [[COERCE3_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP12:%.*]] = load <2 x i32>, ptr [[COERCE3_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP12]], ptr [[__P0_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_1501_I_I:%.*]] = load <4 x bfloat>, ptr [[__P0_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[__P0_1501_I_I]], ptr [[__REINT_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP15:%.*]] = load <4 x i16>, ptr [[__REINT_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP16:%.*]] = bitcast <4 x i16> [[TMP15]] to <8 x i8>
// CHECK-A32-SOFTFP-NEXT:    [[TMP17:%.*]] = sext <4 x i16> [[TMP15]] to <4 x i32>
// CHECK-A32-SOFTFP-NEXT:    [[VSHLL_N_I_I:%.*]] = shl <4 x i32> [[TMP17]], <i32 16, i32 16, i32 16, i32 16>
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[VSHLL_N_I_I]], ptr [[__REINT1_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP19:%.*]] = load <4 x float>, ptr [[__REINT1_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    ret <4 x float> [[TMP19]]
//
float32x4_t test_vcvtq_low_f32_bf16(bfloat16x8_t a) {
  return vcvtq_low_f32_bf16(a);
}

// CHECK-A64-LABEL: @test_vcvtq_high_f32_bf16(
// CHECK-A64-NEXT:  entry:
// CHECK-A64-NEXT:    [[__REINT_150_I_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A64-NEXT:    [[__REINT1_150_I_I:%.*]] = alloca <4 x i32>, align 16
// CHECK-A64-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x bfloat> [[A:%.*]], <8 x bfloat> [[A]], <4 x i32> <i32 4, i32 5, i32 6, i32 7>
// CHECK-A64-NEXT:    store <4 x bfloat> [[SHUFFLE_I]], ptr [[__REINT_150_I_I]], align 8
// CHECK-A64-NEXT:    [[TMP1:%.*]] = load <4 x i16>, ptr [[__REINT_150_I_I]], align 8
// CHECK-A64-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CHECK-A64-NEXT:    [[TMP3:%.*]] = sext <4 x i16> [[TMP1]] to <4 x i32>
// CHECK-A64-NEXT:    [[VSHLL_N_I_I:%.*]] = shl <4 x i32> [[TMP3]], <i32 16, i32 16, i32 16, i32 16>
// CHECK-A64-NEXT:    store <4 x i32> [[VSHLL_N_I_I]], ptr [[__REINT1_150_I_I]], align 16
// CHECK-A64-NEXT:    [[TMP5:%.*]] = load <4 x float>, ptr [[__REINT1_150_I_I]], align 16
// CHECK-A64-NEXT:    ret <4 x float> [[TMP5]]
//
// CHECK-A32-HARDFP-LABEL: @test_vcvtq_high_f32_bf16(
// CHECK-A32-HARDFP-NEXT:  entry:
// CHECK-A32-HARDFP-NEXT:    [[__REINT_150_I_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-HARDFP-NEXT:    [[__REINT1_150_I_I:%.*]] = alloca <4 x i32>, align 8
// CHECK-A32-HARDFP-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x bfloat> [[A:%.*]], <8 x bfloat> [[A]], <4 x i32> <i32 4, i32 5, i32 6, i32 7>
// CHECK-A32-HARDFP-NEXT:    store <4 x bfloat> [[SHUFFLE_I]], ptr [[__REINT_150_I_I]], align 8
// CHECK-A32-HARDFP-NEXT:    [[TMP1:%.*]] = load <4 x i16>, ptr [[__REINT_150_I_I]], align 8
// CHECK-A32-HARDFP-NEXT:    [[TMP2:%.*]] = bitcast <4 x i16> [[TMP1]] to <8 x i8>
// CHECK-A32-HARDFP-NEXT:    [[TMP3:%.*]] = sext <4 x i16> [[TMP1]] to <4 x i32>
// CHECK-A32-HARDFP-NEXT:    [[VSHLL_N_I_I:%.*]] = shl <4 x i32> [[TMP3]], <i32 16, i32 16, i32 16, i32 16>
// CHECK-A32-HARDFP-NEXT:    store <4 x i32> [[VSHLL_N_I_I]], ptr [[__REINT1_150_I_I]], align 8
// CHECK-A32-HARDFP-NEXT:    [[TMP5:%.*]] = load <4 x float>, ptr [[__REINT1_150_I_I]], align 8
// CHECK-A32-HARDFP-NEXT:    ret <4 x float> [[TMP5]]
//
// CHECK-A32-SOFTFP-LABEL: @test_vcvtq_high_f32_bf16(
// CHECK-A32-SOFTFP-NEXT:  entry:
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_I2:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_150_I_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__REINT_150_I_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__REINT1_150_I_I:%.*]] = alloca <4 x i32>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_I:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE_I:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE2_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE3_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[A:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[A_COERCE:%.*]], ptr [[A]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[A1:%.*]] = load <8 x bfloat>, ptr [[A]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[A1]], ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[TMP2]], ptr [[__P0_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P01_I:%.*]] = load <8 x bfloat>, ptr [[__P0_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[__P01_I]], ptr [[COERCE_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP5:%.*]] = load <4 x i32>, ptr [[COERCE_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[TMP5]], ptr [[__P0_I2]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P01_I5:%.*]] = load <8 x bfloat>, ptr [[__P0_I2]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x bfloat> [[__P01_I5]], <8 x bfloat> [[__P01_I5]], <4 x i32> <i32 4, i32 5, i32 6, i32 7>
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[SHUFFLE_I]], ptr [[RETVAL_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP8:%.*]] = load <2 x i32>, ptr [[RETVAL_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP8]], ptr [[COERCE2_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP10:%.*]] = load <4 x bfloat>, ptr [[COERCE2_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[TMP10]], ptr [[COERCE3_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP12:%.*]] = load <2 x i32>, ptr [[COERCE3_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP12]], ptr [[__P0_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_1501_I_I:%.*]] = load <4 x bfloat>, ptr [[__P0_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[__P0_1501_I_I]], ptr [[__REINT_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP15:%.*]] = load <4 x i16>, ptr [[__REINT_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP16:%.*]] = bitcast <4 x i16> [[TMP15]] to <8 x i8>
// CHECK-A32-SOFTFP-NEXT:    [[TMP17:%.*]] = sext <4 x i16> [[TMP15]] to <4 x i32>
// CHECK-A32-SOFTFP-NEXT:    [[VSHLL_N_I_I:%.*]] = shl <4 x i32> [[TMP17]], <i32 16, i32 16, i32 16, i32 16>
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[VSHLL_N_I_I]], ptr [[__REINT1_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP19:%.*]] = load <4 x float>, ptr [[__REINT1_150_I_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    ret <4 x float> [[TMP19]]
//
float32x4_t test_vcvtq_high_f32_bf16(bfloat16x8_t a) {
  return vcvtq_high_f32_bf16(a);
}

// CHECK-A64-LABEL: @test_vcvt_bf16_f32(
// CHECK-A64-NEXT:  entry:
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <16 x i8>
// CHECK-A64-NEXT:    [[__A64_VCVTQ_LOW_BF16_V1_I:%.*]] = call <8 x bfloat> @llvm.aarch64.neon.bfcvtn(<4 x float> [[A]])
// CHECK-A64-NEXT:    [[__A64_VCVTQ_LOW_BF16_V2_I:%.*]] = bitcast <8 x bfloat> [[__A64_VCVTQ_LOW_BF16_V1_I]] to <16 x i8>
// CHECK-A64-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x bfloat> [[__A64_VCVTQ_LOW_BF16_V1_I]], <8 x bfloat> [[__A64_VCVTQ_LOW_BF16_V1_I]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
// CHECK-A64-NEXT:    ret <4 x bfloat> [[SHUFFLE_I]]
//
// CHECK-A32-HARDFP-LABEL: @test_vcvt_bf16_f32(
// CHECK-A32-HARDFP-NEXT:  entry:
// CHECK-A32-HARDFP-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <16 x i8>
// CHECK-A32-HARDFP-NEXT:    [[VCVTFP2BF1_I:%.*]] = call <4 x bfloat> @llvm.arm.neon.vcvtfp2bf.v4bf16(<4 x float> [[A]])
// CHECK-A32-HARDFP-NEXT:    ret <4 x bfloat> [[VCVTFP2BF1_I]]
//
// CHECK-A32-SOFTFP-LABEL: @test_vcvt_bf16_f32(
// CHECK-A32-SOFTFP-NEXT:  entry:
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL_I1:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <16 x i8>
// CHECK-A32-SOFTFP-NEXT:    [[VCVTFP2BF1_I:%.*]] = call <4 x i16> @llvm.arm.neon.vcvtfp2bf.v4i16(<4 x float> [[A]])
// CHECK-A32-SOFTFP-NEXT:    [[TMP1:%.*]] = bitcast <4 x i16> [[VCVTFP2BF1_I]] to <4 x bfloat>
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[TMP1]], ptr [[RETVAL_I1]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP3:%.*]] = load <2 x i32>, ptr [[RETVAL_I1]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP3]], ptr [[COERCE_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP5:%.*]] = load <4 x bfloat>, ptr [[COERCE_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[TMP5]], ptr [[RETVAL_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP7:%.*]] = load <2 x i32>, ptr [[RETVAL_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP7]], ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP9:%.*]] = load <4 x bfloat>, ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[TMP9]], ptr [[RETVAL]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP11:%.*]] = load <2 x i32>, ptr [[RETVAL]], align 8
// CHECK-A32-SOFTFP-NEXT:    ret <2 x i32> [[TMP11]]
//
bfloat16x4_t test_vcvt_bf16_f32(float32x4_t a) {
  return vcvt_bf16_f32(a);
}

// CHECK-A64-LABEL: @test_vcvtq_low_bf16_f32(
// CHECK-A64-NEXT:  entry:
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <16 x i8>
// CHECK-A64-NEXT:    [[__A64_VCVTQ_LOW_BF16_V1_I:%.*]] = call <8 x bfloat> @llvm.aarch64.neon.bfcvtn(<4 x float> [[A]])
// CHECK-A64-NEXT:    [[__A64_VCVTQ_LOW_BF16_V2_I:%.*]] = bitcast <8 x bfloat> [[__A64_VCVTQ_LOW_BF16_V1_I]] to <16 x i8>
// CHECK-A64-NEXT:    ret <8 x bfloat> [[__A64_VCVTQ_LOW_BF16_V1_I]]
//
// CHECK-A32-HARDFP-LABEL: @test_vcvtq_low_bf16_f32(
// CHECK-A32-HARDFP-NEXT:  entry:
// CHECK-A32-HARDFP-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <16 x i8>
// CHECK-A32-HARDFP-NEXT:    [[VCVTFP2BF1_I:%.*]] = call <4 x bfloat> @llvm.arm.neon.vcvtfp2bf.v4bf16(<4 x float> [[A]])
// CHECK-A32-HARDFP-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <4 x bfloat> zeroinitializer, <4 x bfloat> [[VCVTFP2BF1_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
// CHECK-A32-HARDFP-NEXT:    ret <8 x bfloat> [[SHUFFLE_I]]
//
// CHECK-A32-SOFTFP-LABEL: @test_vcvtq_low_bf16_f32(
// CHECK-A32-SOFTFP-NEXT:  entry:
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL_I4:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P1_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL_I1:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL_I:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE1_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE2_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE4_I:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <16 x i8>
// CHECK-A32-SOFTFP-NEXT:    [[VCVTFP2BF1_I:%.*]] = call <4 x i16> @llvm.arm.neon.vcvtfp2bf.v4i16(<4 x float> [[A]])
// CHECK-A32-SOFTFP-NEXT:    [[TMP1:%.*]] = bitcast <4 x i16> [[VCVTFP2BF1_I]] to <4 x bfloat>
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[TMP1]], ptr [[RETVAL_I1]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP3:%.*]] = load <2 x i32>, ptr [[RETVAL_I1]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP3]], ptr [[COERCE_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP5:%.*]] = load <4 x bfloat>, ptr [[COERCE_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> zeroinitializer, ptr [[COERCE1_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP7:%.*]] = load <2 x i32>, ptr [[COERCE1_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[TMP5]], ptr [[COERCE2_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP9:%.*]] = load <2 x i32>, ptr [[COERCE2_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP7]], ptr [[__P0_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P01_I:%.*]] = load <4 x bfloat>, ptr [[__P0_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP9]], ptr [[__P1_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P12_I:%.*]] = load <4 x bfloat>, ptr [[__P1_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <4 x bfloat> [[__P01_I]], <4 x bfloat> [[__P12_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[SHUFFLE_I]], ptr [[RETVAL_I4]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP13:%.*]] = load <4 x i32>, ptr [[RETVAL_I4]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[TMP13]], ptr [[COERCE4_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP15:%.*]] = load <8 x bfloat>, ptr [[COERCE4_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[TMP15]], ptr [[RETVAL_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP17:%.*]] = load <4 x i32>, ptr [[RETVAL_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[TMP17]], ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP19:%.*]] = load <8 x bfloat>, ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[TMP19]], ptr [[RETVAL]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP21:%.*]] = load <4 x i32>, ptr [[RETVAL]], align 8
// CHECK-A32-SOFTFP-NEXT:    ret <4 x i32> [[TMP21]]
//
bfloat16x8_t test_vcvtq_low_bf16_f32(float32x4_t a) {
  return vcvtq_low_bf16_f32(a);
}

// CHECK-A64-LABEL: @test_vcvtq_high_bf16_f32(
// CHECK-A64-NEXT:  entry:
// CHECK-A64-NEXT:    [[TMP0:%.*]] = bitcast <8 x bfloat> [[INACTIVE:%.*]] to <16 x i8>
// CHECK-A64-NEXT:    [[TMP1:%.*]] = bitcast <4 x float> [[A:%.*]] to <16 x i8>
// CHECK-A64-NEXT:    [[VCVTQ_HIGH_BF16_V2_I:%.*]] = call <8 x bfloat> @llvm.aarch64.neon.bfcvtn2(<8 x bfloat> [[INACTIVE]], <4 x float> [[A]])
// CHECK-A64-NEXT:    [[VCVTQ_HIGH_BF16_V3_I:%.*]] = bitcast <8 x bfloat> [[VCVTQ_HIGH_BF16_V2_I]] to <16 x i8>
// CHECK-A64-NEXT:    ret <8 x bfloat> [[VCVTQ_HIGH_BF16_V2_I]]
//
// CHECK-A32-HARDFP-LABEL: @test_vcvtq_high_bf16_f32(
// CHECK-A32-HARDFP-NEXT:  entry:
// CHECK-A32-HARDFP-NEXT:    [[TMP0:%.*]] = bitcast <4 x float> [[A:%.*]] to <16 x i8>
// CHECK-A32-HARDFP-NEXT:    [[VCVTFP2BF1_I:%.*]] = call <4 x bfloat> @llvm.arm.neon.vcvtfp2bf.v4bf16(<4 x float> [[A]])
// CHECK-A32-HARDFP-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x bfloat> [[INACTIVE:%.*]], <8 x bfloat> [[INACTIVE]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
// CHECK-A32-HARDFP-NEXT:    [[SHUFFLE_I8:%.*]] = shufflevector <4 x bfloat> [[VCVTFP2BF1_I]], <4 x bfloat> [[SHUFFLE_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
// CHECK-A32-HARDFP-NEXT:    ret <8 x bfloat> [[SHUFFLE_I8]]
//
// CHECK-A32-SOFTFP-LABEL: @test_vcvtq_high_bf16_f32(
// CHECK-A32-SOFTFP-NEXT:  entry:
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL_I11:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_I12:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P1_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL_I8:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL_I3:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_I4:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL_I:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P0_I:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE2_I:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE4_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE5_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE6_I:%.*]] = alloca <4 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE8_I:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[RETVAL:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[INACTIVE:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    [[COERCE2:%.*]] = alloca <8 x bfloat>, align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[INACTIVE_COERCE:%.*]], ptr [[INACTIVE]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[INACTIVE1:%.*]] = load <8 x bfloat>, ptr [[INACTIVE]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[INACTIVE1]], ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr [[COERCE]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[TMP2]], ptr [[__P0_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P01_I:%.*]] = load <8 x bfloat>, ptr [[__P0_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP4:%.*]] = bitcast <4 x float> [[A:%.*]] to <16 x i8>
// CHECK-A32-SOFTFP-NEXT:    [[VCVTFP2BF1_I:%.*]] = call <4 x i16> @llvm.arm.neon.vcvtfp2bf.v4i16(<4 x float> [[A]])
// CHECK-A32-SOFTFP-NEXT:    [[TMP5:%.*]] = bitcast <4 x i16> [[VCVTFP2BF1_I]] to <4 x bfloat>
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[TMP5]], ptr [[RETVAL_I8]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP7:%.*]] = load <2 x i32>, ptr [[RETVAL_I8]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP7]], ptr [[COERCE_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP9:%.*]] = load <4 x bfloat>, ptr [[COERCE_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[__P01_I]], ptr [[COERCE2_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP11:%.*]] = load <4 x i32>, ptr [[COERCE2_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[TMP11]], ptr [[__P0_I4]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P01_I7:%.*]] = load <8 x bfloat>, ptr [[__P0_I4]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x bfloat> [[__P01_I7]], <8 x bfloat> [[__P01_I7]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[SHUFFLE_I]], ptr [[RETVAL_I3]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP14:%.*]] = load <2 x i32>, ptr [[RETVAL_I3]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP14]], ptr [[COERCE4_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP16:%.*]] = load <4 x bfloat>, ptr [[COERCE4_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[TMP9]], ptr [[COERCE5_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP18:%.*]] = load <2 x i32>, ptr [[COERCE5_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x bfloat> [[TMP16]], ptr [[COERCE6_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP20:%.*]] = load <2 x i32>, ptr [[COERCE6_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP18]], ptr [[__P0_I12]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P01_I16:%.*]] = load <4 x bfloat>, ptr [[__P0_I12]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <2 x i32> [[TMP20]], ptr [[__P1_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[__P12_I:%.*]] = load <4 x bfloat>, ptr [[__P1_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[SHUFFLE_I17:%.*]] = shufflevector <4 x bfloat> [[__P01_I16]], <4 x bfloat> [[__P12_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[SHUFFLE_I17]], ptr [[RETVAL_I11]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP24:%.*]] = load <4 x i32>, ptr [[RETVAL_I11]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[TMP24]], ptr [[COERCE8_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP26:%.*]] = load <8 x bfloat>, ptr [[COERCE8_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[TMP26]], ptr [[RETVAL_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP28:%.*]] = load <4 x i32>, ptr [[RETVAL_I]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <4 x i32> [[TMP28]], ptr [[COERCE2]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP30:%.*]] = load <8 x bfloat>, ptr [[COERCE2]], align 8
// CHECK-A32-SOFTFP-NEXT:    store <8 x bfloat> [[TMP30]], ptr [[RETVAL]], align 8
// CHECK-A32-SOFTFP-NEXT:    [[TMP32:%.*]] = load <4 x i32>, ptr [[RETVAL]], align 8
// CHECK-A32-SOFTFP-NEXT:    ret <4 x i32> [[TMP32]]
//
bfloat16x8_t test_vcvtq_high_bf16_f32(bfloat16x8_t inactive, float32x4_t a) {
  return vcvtq_high_bf16_f32(inactive, a);
}

// CHECK-A64-LABEL: @test_vcvth_bf16_f32(
// CHECK-A64-NEXT:  entry:
// CHECK-A64-NEXT:    [[VCVTH_BF16_F32_I:%.*]] = call bfloat @llvm.aarch64.neon.bfcvt(float [[A:%.*]])
// CHECK-A64-NEXT:    ret bfloat [[VCVTH_BF16_F32_I]]
//
// CHECK-A32-HARDFP-LABEL: @test_vcvth_bf16_f32(
// CHECK-A32-HARDFP-NEXT:  entry:
// CHECK-A32-HARDFP-NEXT:    [[VCVTBFP2BF_I:%.*]] = call bfloat @llvm.arm.neon.vcvtbfp2bf(float [[A:%.*]])
// CHECK-A32-HARDFP-NEXT:    ret bfloat [[VCVTBFP2BF_I]]
//
// CHECK-A32-SOFTFP-LABEL: @test_vcvth_bf16_f32(
// CHECK-A32-SOFTFP-NEXT:  entry:
// CHECK-A32-SOFTFP-NEXT:    [[VCVTBFP2BF_I:%.*]] = call bfloat @llvm.arm.neon.vcvtbfp2bf(float [[A:%.*]])
// CHECK-A32-SOFTFP-NEXT:    ret bfloat [[VCVTBFP2BF_I]]
//
bfloat16_t test_vcvth_bf16_f32(float32_t a) {
  return vcvth_bf16_f32(a);
}

// CHECK-LABEL: @test_vcvtah_f32_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[__REINT_I:%.*]] = alloca bfloat, align 2
// CHECK-NEXT:    [[__REINT1_I:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store bfloat [[A:%.*]], ptr [[__REINT_I]], align 2
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[__REINT_I]], align 2
// CHECK-NEXT:    [[SHL_I:%.*]] = shl i32 [[TMP1]], 16
// CHECK-NEXT:    store i32 [[SHL_I]], ptr [[__REINT1_I]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = load float, ptr [[__REINT1_I]], align 4
// CHECK-NEXT:    ret float [[TMP3]]
//
float32_t test_vcvtah_f32_bf16(bfloat16_t a) {
  return vcvtah_f32_bf16(a);
}

